global quoteMark
set quoteMark to "\""

global file_name
global new_loc

        set ThePrefix to "%@"
        set TheResultsFile to (path to home folder from user domain as text) & "%@"
	set TheImporter to "%@"

set LF to ASCII character 10

with timeout of (30 * 60) seconds
	
	tell application "iTunes.app"

	-- If needed make a playlist to hold them all
	set TheConvertedItemsPlaylistName to TheImporter & " From " & ThePrefix
	set DidFindTheConvertedItemsPlaylist to 0
        repeat with i from 1 to the count of playlists
                set TheSource to playlist i
                if name of TheSource begins with TheConvertedItemsPlaylistName then
                        set DidFindTheConvertedItemsPlaylist to 1 
                        set TheConvertedItemsPlaylist to TheSource
			exit repeat
                end if
        end repeat

	if DidFindTheConvertedItemsPlaylist is equal to 0 then
		set TheConvertedItemsPlaylist to (make new playlist with properties {name:TheConvertedItemsPlaylistName})
	end if

-- Okay, first let's set encoder properties.
		set old_encoder to current encoder
		set available_encoders to (name of encoders)
		repeat with an_encoder in available_encoders
			if format of encoder an_encoder is TheImporter then
				-- Set Selected  encoder
				set current encoder to encoder an_encoder
				exit repeat
			end if
		end repeat
		
		set TheCD to some source whose kind is audio CD and name ends with ThePrefix & " CD"
		set ThePlaylist to (get playlist 1 of TheCD)
		
		set tracklist to (get every track of ThePlaylist)

		-- encode the tracks.
		set converted_tracklist to (convert tracklist)
		
		copy (count converted_tracklist) to ix
		
		set trackCount to 0

		repeat with a_track in converted_tracklist
			
			duplicate a_track to TheConvertedItemsPlaylist	

			set track_name to (get name of a_track)
			
				set new_loc to location of a_track
				tell application "Finder"
					set file_name to the name of new_loc
				end tell
				
			set trackCount to trackCount + 1
	
		end repeat
	
		-- reinstate the old encoder
		set current encoder to old_encoder
		
        try
                set results_fd to open for access file TheResultsFile with write permission
                on error
                        close access file TheResultsFile
                        set results_fd to open for access file TheResultsFile with write permission
                end try

                set eof of results_fd to 0
                write "<?xml version=" & quoteMark & "1.0" & quoteMark & " encoding=" & quoteMark & "UTF-8" & quoteMark & "?>" & LF to results_fd
                write "<!DOCTYPE plist PUBLIC " & quoteMark & "-//Apple Computer//DTD PLIST 1.0//EN" & quoteMark & " " & quoteMark & "http://www.apple.com/DTDs/PropertyList-1.0.dtd" & quoteMark & ">" & LF to results_fd
                write "<plist version=" & quoteMark & "1.0" & quoteMark & ">" & LF to results_fd
                write "<dict>" & LF to results_fd
                write tab & "<key>trackstoconvert</key>" & LF to results_fd
                write tab & "<integer>" & (get trackCount as string) & "</integer>" & LF to results_fd
                write "</dict>" & LF to results_fd
                write "</plist>" & LF to results_fd
                close access results_fd
		


	end tell
end timeout

